/* opcodes.h -- opcode encodings
 *
 * last edited: Mon Mar 16 19:26:57 1998 by piumarta (Ian Piumarta) on clotho
 */

#ifndef _opcodes_h_
#define _opcodes_h_

enum {

  op_halt= 0,
	/* terminate execution; return result on top of stack to caller.
	   FORMAT:	halt

	   STACK:	<result> ...  =>				*/

  op_locals,
	/* reserve space on stack for local variables.
	   FORMAT:	locals
			<N = words to reserve>
	   STACK:	...  =>  <N words of space> ...			*/

  op_push,
	/* push integer literal onto stack.
	   FORMAT:	push
			<integerLiteral>
	   STACK:	...  =>  <integerLiteral> ...			*/

  op_pushArg,
	/* push argument variable onto stack.
	   FORMAT:	pushArg
			<N = 0-based argument index>
	   STACK:	...  =>  <argN> ...				*/

  op_pushLocal,
	/* push local variable onto stack.
	   FORMAT:	pushLocal
			<0-based local index>
	   STACK:	...  =>  <localN> ...				*/

  op_pop,
	/* pop top item off stack.
	   FORMAT:	pop
	   STACK:	<value> ...  =>  ...				*/

  op_assignArg,
	/* store top of stack into argument variable; do not pop the stack.
	   FORMAT:	assignArg
			<0-based argument index>
	   STACK:	value ...  =>  value ...			*/

  op_assignLocal,
	/* store top of stack into local variable; do not pop the stack.
	   FORMAT:	assignLocal
			<0-based local index>
	   STACK:	<value> ...  =>  <value> ...			*/

  op_less,
	/* pop two items; push true if 2os < tos.
	   FORMAT:	less
	   STACK:	a b ...  =>  (b<a) ...				*/

  op_lessEqual,
	/* pop two items; push true if 2os <= tos.
	   FORMAT:	lessEqual
	   STACK:	a b ...  =>  (b<=a) ...				*/

  op_equal,
	/* pop two items; push true if 2os == tos.
	   FORMAT:	equal
	   STACK:	a b ...  =>  (b==a) ...				*/

  op_notEqual,
	/* pop two items; push true if 2os != tos.
	   FORMAT:	notEqual
	   STACK:	a b ...  =>  (b!=a) ...				*/

  op_greaterEqual,
	/* pop two items; push true if 2os >= tos.
	   FORMAT:	greaterEqual
	   STACK:	a b ...  =>  (b>=a) ...				*/

  op_greater,
	/* pop two items; push true if 2os > tos.
	   FORMAT:	greater
	   STACK:	a b ...  =>  (b>a) ...				*/

  op_add,
	/* pop two items; push sum.
	   FORMAT:	add
	   STACK:	a b ...  =>  (a+b) ...				*/

  op_subtract,
	/* pop two items; push 2os - tos.
	   FORMAT:	subtract
	   STACK:	a b ...  =>  (b-a) ...				*/

  op_multiply,
	/* pop two items; push product.
	   FORMAT:	multiply
	   STACK:	a b ...  =>  (a*b) ...				*/

  op_divide,
	/* pop two items; push 2os / tos.
	   FORMAT:	divide
	   STACK:	a b ...  =>  (b/a) ...				*/

  op_negate,
	/* pop one item; push two's complement.
	   FORMAT:	negate
	   STACK:	a ...  =>  (-a) ...				*/

  op_call,
	/* call a function.
	   FORMAT:	call
			<N = argumentCount>
	   STACK:	<N arguments> <address> ...
		    =>  <frame> <N arguments> <address> ...		*/

  op_return,
	/* return from function.
	   FORMAT:	return
	   STACK:	<result> ...1 <frame> <N arguments> <addr> ...2
		    =>	<result> ...2					*/

  op_jump,
	/* jump by a word displacement relative to next instruction.
	   FORMAT:	jump
			<displacement>					*/

  op_jumpIfFalse,
	/* jump by word displacement if tos is false; pop stack.
	   FORMAT:	jumpIfFalse
			<displacement>
	   STACK:	<condition> ...	 =>  ...			*/

  op_new,
	/* pop size; allocate size words of memory; push memory address.
	   FORMAT:	new
	   STACK:	<wordSize> ...  =>  <address> ...		*/

  op_get,
	/* read an element from an array.
	   FORMAT:	get
	   STACK:	<addr> <index> ...  =>  <addr[index]> ...	*/

  op_put,
	/* store a value into an array.
	   FORMAT:	put
	   STACK:	<value> <addr> <index> ...  =>  <value> ...	*/

  op_print,
	/* pop integer off stack and print it.
	   FORMAT:	print
	   STACK:	<value> ...  =>  ...				*/

  op_MAX
	/* dummy: used only to record the number of opcodes */
};

#endif _opcodes_h_
