/* Yo, Emacs!  Let's pretend that this is -*- C++ -*- 
 *
 * parser.y -- bison ONLY grammar (mid-rule actions will probably confuse yacc)
 *
 * last edited: Mon Apr 13 18:09:50 1998 by piumarta (Ian Piumarta) on pingu
 */

%{
#define  YYDEBUG 1
#define  YYERROR_VERBOSE
#include "yy.h"
#include "generate.h"
%}

/*%pure_parser*/

%token IDENTIFIER NUMBER STRING
%token WHILE IF ELSE LOCAL NEW DELETE PRINT RETURN
%token LEQ EQL NEQ GEQ

%expect 1 /* shift/reduce conflict: the usual "dangling else" thing */

%%

program:
  /* empty */			{ fprintf(stderr, "no source?\n"); }
| declarations			{ execute(); }
;

declarations:
  declaration
| declarations declaration
;

declaration:
  identifier			{ startFunction($1); }
  '(' formals ')' locals stmt	{ endFunction($1); }
;

formals:
 /* empty */
| commaIds
;

commaIds:
  identifier			{ defArgument($1); }
| commaIds ',' identifier	{ defArgument($3); }

locals:
  /* empty */
| LOCAL localList ';'		{ emit_locals(); }
;

localList:
  local
| localList ',' local
;

local:
  identifier			{ defLocal($1); }
;

stmt:
  ';'				/* null statement */
| exp ';'			{ emit_pop(); }
| PRINT exp ';'			{ emit_print(); }
| DELETE exp ';'		{ emit_delete(); }
| WHILE				{ newLabel(); newLabel(); defLabel(0); }
    '(' exp			{ emit_jumpIfFalse(1); }
    ')' stmt			{ emit_jump(0); defLabel(1); popLabel(); popLabel(); }
| IF '(' exp ')' mkIf stmt	{ defLabel(0); popLabel(); popLabel(); }
| IF '(' exp ')' mkIf stmt ELSE mkElse stmt
				{ defLabel(1); popLabel(); popLabel(); }
| '{' statements '}'
| RETURN exp ';'		{ emit_return(); }
;

/* ugly, but necessary to avoid a reduce/reduce conflict between if and if...else */
mkIf:	{ newLabel(); newLabel(); emit_jumpIfFalse(0); } ;
mkElse:	{ emit_jump(1); defLabel(0); } ;

statements:
  /* empty */
| statements stmt
;

exp:
  relop
| identifier '=' exp		{ emit_assign($1); }
| identifier '[' exp ']'	{ emit_variable($1); }
    '=' exp			{ emit_put(); }
| NEW exp			{ emit_new(); }
;

relop:
  addop
| addop '<' addop		{ emit_less(); }
| addop LEQ addop		{ emit_lessEqual(); }
| addop EQL addop		{ emit_equal(); }
| addop NEQ addop		{ emit_notEqual(); }
| addop GEQ addop		{ emit_greaterEqual(); }
| addop '>' addop		{ emit_greater(); }
;

addop:
  mulop
| addop '+' mulop		{ emit_add(); }
| addop '-' mulop		{ emit_subtract(); }
;

mulop:
  unaryop
| mulop '*' unaryop		{ emit_multiply(); }
| mulop '/' unaryop		{ emit_divide(); }
;

unaryop:
  applyop
| '-' unaryop			{ emit_negate(); }
;

applyop:
  primary
| applyop '(' actuals ')'	{ emit_call($3); }
| identifier '[' exp ']'	{ emit_variable($1); emit_get(); }
;

actuals:
  /* empty */			{ $$= 0; }
| commaExps
;

/* NOTE: these are evaluated from left to right.  Caveat VM implementor! */
commaExps:
  exp				{ $$= 1; }
| commaExps ',' exp		{ $$= $1 + 1; }
;

primary:
  literal
| '(' exp ')'
;

literal:
  number		{ emit_push($1); }
| identifier		{ emit_variable($1); }
;

number:
  NUMBER		{ $$= atoi(yytext); }
;

identifier:
  IDENTIFIER		{ $$= newSymbol(yytext); }
;

%%
