/* generate.h -- code generator public interface
 *
 * last edited: Mon Apr 13 18:10:02 1998 by piumarta (Ian Piumarta) on pingu
 */

#ifndef _generate_h_
#define _generate_h_

int  newSymbol(char *name);

void defGlobal(int symbol, int value);
void defArgument(int symbol);
void defLocal(int symbol);

void newLabel(void);
void defLabel(int index);
void popLabel(void);

void startFunction(int symbol);
void endFunction(int symbol);

void emit_variable(int symbol);
void emit_assign(int symbol);
void emit_locals(void);

void emit_halt(void);
void emit_push(int value);
void emit_pushArg(int index);
void emit_pushLocal(int index);
void emit_pop(void);
void emit_assignArg(int index);
void emit_assignLocal(int index);
void emit_less(void);
void emit_lessEqual(void);
void emit_equal(void);
void emit_notEqual(void);
void emit_greaterEqual(void);
void emit_greater(void);
void emit_add(void);
void emit_subtract(void);
void emit_multiply(void);
void emit_divide(void);
void emit_negate(void);
void emit_call(int numArgs);
void emit_return(void);
void emit_jump(int label);
void emit_jumpIfFalse(int label);
void emit_new(void);
void emit_delete(void);
void emit_get(void);
void emit_put(void);
void emit_print(void);

void execute(void);

#endif _generate_h_
