/* label.c -- support for long-range labels
 *
 * last edited: Fri Apr  2 14:44:30 1999 by piumarta (Ian Piumarta) on pingu
 */

#include "label.h"

#include <malloc.h>
#include <stdio.h>

#define new(type)	((type *)malloc(sizeof(type)))
#define delete(obj)	(free(obj))


Label *lbl_new(void)
{
  Label *label= new(Label);
  label->addr= 0;
  label->uses= 0;
  return label;
}


void *lbl_use(void *pc, int opType, Label *label)
{
  if (label->addr != 0) {
    /* backward */
    return label->addr;
  } else {
    /* forward */
    LabelUse *use= new(LabelUse);

    use->op=   opType;
    use->addr= pc;
    use->next= label->uses;

    label->uses= use;
  }
  return pc;
}


void lbl_define(Label *label, void *pc)
{
  label->addr= pc;
  lbl_resolve(label);
}


void lbl_delete(Label *label)
{
  if ((label->addr == 0) && (label->uses != 0)) {
    fprintf(stderr, "labed used but not defined\n");
    abort();
  }
  delete(label);
}
