// Cache.cc -- "Obstack"-like caches for translated code and pc maps
//
// Author: Ian.Piumarta@INRIA.Fr
//
// Last edited: 2000-12-06 14:54:37 by piumarta on emilia.rd.wdi.disney.com

#include "Cache.h"

#include "xmalloc.h"


Cache::Cache(size_t q, char *b)
  : quantum(q), base(b), lwm(b), hwm(b ? (b + q) : 0),
    nBytes(0), nLost(0), nEntries(0), nBlocks(0), reserved(0)
{
  //PRINTF(("0x%08x allocate %sCache\n", (int)this));
}

Cache::~Cache(void)
{
  while (base != 0)
    {
      char *next= *(char **)base;
      xfree(base);
      base= next;
    }
}


char *Cache::reserve(size_t lbs)
{
  lbs= (lbs + 3) & ~3;	// round to nearest word
  reserved= lbs;
  if ((size_t)lwm + lbs < (size_t)hwm)
    {
      return lwm;
    }
  char *next= (char *)xmalloc(quantum);
  if (next == 0)
    fatal("out of memory");
  ++nBlocks;
  nLost+= hwm - lwm;
  *(char **)next= base;
  base= next;
  lwm= base + sizeof(char *);
  hwm= base + quantum;
  return lwm;
}
