// Frame.h -- architecture-independent interface to native stack frames
// 
// Author: Ian.Piumarta@INRIA.Fr
//
// Last edited: 2000-11-21 10:29:34 by piumarta on emilia.rd.wdi.disney.com


#ifndef _j_Frame_h
#define _j_Frame_h


#include "archdep.h"

#include ARCHDEP(Frame.h)



#define GC_PROTECT(FRAME, EXPR)		\
  {					\
    assert(activeFrame == 0);		\
    activeFrame= FRAME;			\
    assert(activeFrame != 0);		\
    EXPR;				\
    assert(0 == (activeFrame= 0));	\
  }


class Frame : public _Frame
{
public:	// export protected inheritance

  inline Frame *senderFrame(void)
    {
      return (Frame *)_Frame::senderFrame();
    }

  inline Frame *calleeFrame(void)
    {
      return (Frame *)_Frame::calleeFrame();
    }


  inline Frame *load(Context *cx)
    {
      return (Frame *)_Frame::load(cx);
    }

  static Frame *loadStack(Context *ctx, char *stackBase, size_t stackSize)
    {
      return (Frame *)_Frame::loadStack(ctx, stackBase, stackSize);
    }

public: // synthesised operations

  void resume(void);

  inline oop &tempAt(int idx)
    {
      assert((idx >= 0) && (idx < (int)stackIndex()));
#    ifdef STACK_GROWS_DOWN
      return stackFirst()[-idx];
#    else
      return stack[idx];
#    endif
    }

  oop instVarAt(int index);
  oop instVarAtPut(int index, oop value);

  oop at(int index);
  oop atPut(int index, oop value);

  bool storeStackp(int index);

  Context *clone(void);
};



static const size_t bx_home_off=	memberOffset(BlockContext, home);
static const size_t mx_receiver_off=	memberOffset(MethodContext, receiver);
static const size_t mx_method_off=	memberOffset(MethodContext, method);


#endif // _j_Frame_h
