// archdep.h -- define the local architecture		-*- C++ -*-
// 
// Author: Ian.Piumarta@INRIA.Fr
//
// Last edited: 2000-11-28 10:03:58 by piumarta on emilia.rd.wdi.disney.com

#ifndef _j_arch_h
#define _j_arch_h

#undef	NEW_FRAMES

// minor discrepancies in CW8 on MacOS

#if defined(__MWERKS__) && !defined(macintosh)
# define macintosh
#endif

#if defined(macintosh)
# if defined(__POWERPC__) && !defined(__powerpc)
#   define __powerpc__
# elif !defined(__m68k__)
#   define __m68k__
# endif
#endif

// consistently inconsistent: assume x86 if we're running some flavour of BillyOS

#if (defined(WIN32) || defined (_WIN32) || defined(Win32)) && !defined(__i386__)
# define __i386__
# ifndef WIND32
#   define WIN32
# endif
#endif

// define the local instruction type iff we've not already included ccg/asm-*.h

#if defined(__ccg_asm_common_h)
# define insn_type(T)
#else
# define insn_type(T)	typedef T insn
#endif

#if defined(__powerpc__)
# define ARCHDEP(X) "ppc-"#X
  insn_type(unsigned int);
#elif defined(__i386__)
# define ARCHDEP(X) "i386-"#X
# define _ASM_SAFETY	1
  insn_type(unsigned char);
#elif defined(__sparc__)
# define ARCHDEP(X) "sparc-"#X
  insn_type(unsigned int);
#else
# error: your architecture is not supported
#endif

#undef insn_type

extern insn *asm_pc;
extern int   asm_pass;

// squash the annoying "alpha release" messages

#define EPEND

// global assembler modifications

#include <sys/types.h>

#define _ASM_APP_1	{
#define _ASM_NOAPP_1	}

#define _ASM_APP_2	{ insn *asm_lwm= asm_pc;			\
			  int prev_pass= asm_pass;			\
			  for (asm_pass= 1; asm_pass < 3; ++asm_pass) {	\
			    asm_pc= asm_lwm; {

#define _ASM_NOAPP_2	}} asm_pass= prev_pass; }

#define memberOffset(TYPE, MEMBER)	((size_t)&(((TYPE *)0)->MEMBER))


// Global config 
#define PROFILER
#define DISASM

#ifdef macintosh
# undef PROFILER
# undef DISASM
#endif

#ifdef WIN32
# undef PROFILER
# undef DISASM
#endif

  


#endif // _j_archdep_h







