// cachebits.h -- flag bits for inline cache argument
//
// Author: Ian.Piumarta@INRIA.Fr
//
// Last edited: 2000-10-23 15:08:47 by piumarta on emilia.rd.wdi.disney.com

#ifndef _j_cachebits_h
#define _j_cachebits_h


/* inline cache argument:

	33222222222211111111110000000000
	10987654321098765432109876543210
	--------------------------------
	SD                            I 	SI cache
	SD             CCCCC          I 	CC cache
	SDHHHHHHHHHHHH    LLLLLLLLLLLLI 	NC cache

	S = SuperedBit
	D = DeferredBit
	C = compact class index
	H = memo major index
	L = memo minor index
	I = indirect cache bit (Real Soon Now ;-)
*/

// flags `or'ed into the inline cache argument

static const unsigned SuperedBit=	0x80000000;
static const unsigned DeferredBit=	0x40000000;
static const unsigned IndirectBit=	0x00000002;
static const unsigned CacheMask=	(SuperedBit | DeferredBit | IndirectBit);

// inline cache types for native methods

static const unsigned pvCacheType=	0;	// polyvalent cache
static const unsigned siCacheType=	1;	// tagged cache
static const unsigned ccCacheType=	2;	// compact cache
static const unsigned ncCacheType=	3;	// noncompact cache
static const unsigned ixCacheType=	4;	// instance-specific indexed cache


// inline cache options

// place naked oops in inline cache (dangerous!)
#undef	OOPS_IN_CACHE


#endif // _j_cachebits_h
