// debug.h -- error handling and debugging stuff
//
// Author: Ian.Piumarta@INRIA.Fr
//
// Last edited: 2/26/01 by marcus@ira.uka.de


#ifndef _j_debug_h
#define _j_debug_h


#include <stdio.h>		// must come before, because of dprintf


extern char *errFile;
extern int   errLine;
extern char *errFunc;

#if !defined(__GNUC__)
# define __PRETTY_FUNCTION__	"<unknown function>"
#endif

extern int fatalError(char *, ...);

#define fatal ( \
  (errFile= __FILE__), \
  (errLine= __LINE__), \
  (errFunc= __PRETTY_FUNCTION__), \
  fatalError)


#ifdef DEBUG
# define FPRINTF(ARGS)		fprintf ARGS
# define PRINTF(ARGS)		printf ARGS
# define PRINT(OBJ)		((OBJ)->print())
# define CR()			putchar('\n')
#else
# define FPRINTF(ARGS)
# define PRINTF(ARGS)
# define PRINT(OBJ)
# define CR()
#endif

#define PRINTLN(OBJ)		PRINT(OBJ); CR()

#define println(OBJ)		(OBJ)->print(); putchar('\n')


#ifndef NDEBUG
  extern void assertionFail(char *, int, char *, char*);
# define assert(X) \
    if (!(X)) assertionFail(__FILE__, __LINE__, __PRETTY_FUNCTION__, #X)
#else
# define assert(X)
#endif


// this doesn't belong here, but it's a convenient place...

static inline float percent(int num, int den)
{
  return den < 1 ? 0.0 : ((float)num * 100.0) / (float)den;
}

#ifdef __cplusplus
extern "C" {
#endif

  void myBreak(void);

#ifdef __cplusplus
}
#endif

#endif // _j_debug_h
