// genValue.cc -- value method prologue generation		-*- C++ -*-
// 
// Author: Ian.Piumarta@INRIA.Fr
//
// Last edited: Thu Sep 14 01:43:05 2000 by piumarta (Ian Piumarta) on emilia

#include "archdep.h"
#include "generate.h"
#include "machine.h"

#include ARCHDEP(emit.h)


void genValue(NativeMethod *nMeth)
{
# if defined(USE_CLOSURE_CACHE)
  const int nArgs= nMeth->argumentCount;
  const int bx_nargs_off= memberOffset(BlockContext, nargs);
  const int bx_entry_off= memberOffset(BlockContext, stack[ClosureCacheIndex]);
  // ixCacheCheck has identified the receiver (reg[0]) as a BlockClosure
  insn *asm_org= asm_pc, *fail= asm_pc;
  for (asm_pass= 1; asm_pass < 3; ++asm_pass)
    {
      asm_pc= asm_org;
      //emit_move_S_r(nArgs, reg[0]); // !!!
      emit_get_i_r_r(bx_nargs_off, reg[0], tmp[0]);
      emit_cmp_r_i(tmp[0], (int)Object::integer(nArgs));
      emit_bne(fail);
      emit_get_i_r_r(bx_entry_off, reg[0], tmp[0]);	// entry point
      emit_cmp_r_i(tmp[0], 0);
      emit_beq(fail);					// not cached
      emit_jmp_r(tmp[0]);
      fail= asm_pc;
    }
  asm_pass= 0;
  // ASSUME: call to controlPrimitive response follows immediately
  // to cope with the case where the entry point was not cached.
# endif // USE_CLOSURE_CACHE
}
