// machine.h -- Squeak Abstract Machine, native stack frame version
// 
// Author: Ian.Piumarta@INRIA.Fr
// 
// Last edited: 2000-11-20 10:04:16 by piumarta on emilia.rd.wdi.disney.com

#ifndef _j_machine_h
#define _j_machine_h


#include "archdep.h"	// typedef insn

#undef IC_STATS

// do not define this
#define	BLOCK_CLOSURES

// do not define this either
#undef	USE_CLOSURE_CACHE
#define ClosureCacheIndex	11

#ifndef BLOCK_CLOSURES
# undef USE_CLOSURE_CACHE
#endif


extern unsigned siTraps;
extern unsigned tfTraps;


class Object;
class BlockContext;
class Frame;
class NativeMethod;

class ICLine;

typedef Object *oop;

extern Frame *activeFrame;


#if 0
extern bool   c_primitive	(Frame *frame, NativeMethod *nMeth);
extern insn  *c_controlPrimitive(Frame *frame, NativeMethod *nMeth);
#endif
extern void   c_activate	(Frame *frame, NativeMethod *nMeth);

extern insn  *c_relink		(Frame *frame, NativeMethod *nMeth,
				 insn *dssIP, unsigned flags, ICLine *icl);

extern Frame *c_cxFault		(Frame *frame);
extern Frame *c_mxFault		(Frame *frame);

extern void   c_Pop		(Frame *frame);
extern void   c_Dup		(Frame *frame);
extern void   c_LdSelf		(Frame *frame);
extern void   c_bLdSelf		(Frame *frame);
extern void   c_LdTrue		(Frame *frame);
extern void   c_LdFalse		(Frame *frame);
extern void   c_LdNil		(Frame *frame);
extern void   c_LdInt		(Frame *frame, int val);
extern void   c_LdThisContext	(Frame *frame);
extern void   c_LdLit		(Frame *frame, int idx);
extern void   c_bLdLit		(Frame *frame, int idx);
extern void   c_LdInst		(Frame *frame, int idx);
extern void   c_bLdInst		(Frame *frame, int idx);
extern void   c_pLdInst		(Frame *frame, int idx);
extern void   c_bpLdInst	(Frame *frame, int idx);
extern void   c_StInst		(Frame *frame, int idx);
extern void   c_bStInst		(Frame *frame, int idx);
extern void   c_pStInst		(Frame *frame, int idx);
extern void   c_bpStInst	(Frame *frame, int idx);
extern void   c_PopInst		(Frame *frame, int idx);
extern void   c_bPopInst	(Frame *frame, int idx);
extern void   c_pPopInst	(Frame *frame, int idx);
extern void   c_bpPopInst	(Frame *frame, int idx);
extern void   c_LdTemp		(Frame *frame, int idx);
extern void   c_bLdTemp		(Frame *frame, int idx);
extern void   c_StTemp		(Frame *frame, int idx);
extern void   c_bStTemp		(Frame *frame, int idx);
extern void   c_LdLitInd	(Frame *frame, int idx);
extern void   c_bLdLitInd	(Frame *frame, int idx);
extern void   c_StLitInd	(Frame *frame, int idx);
extern void   c_bStLitInd	(Frame *frame, int idx);

extern insn  *c_Jmp		(Frame *frame, insn *dest);
extern insn  *c_JmpF		(Frame *frame, insn *dest);
extern insn  *c_JmpT		(Frame *frame, insn *dest);

extern insn  *c_SuperUnlinked	(Frame *frame, int selArgs);
extern insn  *c_SendUnlinked	(Frame *frame, int selArgs);
extern insn  *c_SpecialUnlinked	(Frame *frame, int selArgs);
extern insn  *c_SpecialDeferred	(Frame *frame, int selArgs, insn *dssIP);

extern Frame *c_LocalRetSelf	(Frame *frame);
extern Frame *c_bLocalRetSelf	(Frame *frame);
extern Frame *c_LocalRetTrue	(Frame *frame);
extern Frame *c_LocalRetFalse	(Frame *frame);
extern Frame *c_LocalRetNil	(Frame *frame);
extern Frame *c_LocalRetTop	(Frame *frame);

extern Frame *c_RemoteRetSelf	(Frame *frame);
extern Frame *c_RemoteRetTrue	(Frame *frame);
extern Frame *c_RemoteRetFalse	(Frame *frame);
extern Frame *c_RemoteRetNil	(Frame *frame);
extern Frame *c_RemoteRetTop	(Frame *frame);

extern insn  *c_Add		(Frame *frame);
extern insn  *c_Subtract	(Frame *frame);
extern insn  *c_LessThan	(Frame *frame);
extern insn  *c_GreaterThan	(Frame *frame);
extern insn  *c_LessOrEqual	(Frame *frame);
extern insn  *c_GreaterOrEqual	(Frame *frame);
extern insn  *c_Equal		(Frame *frame);
extern insn  *c_NotEqual	(Frame *frame);
extern insn  *c_Multiply	(Frame *frame);
extern insn  *c_Divide		(Frame *frame);
extern insn  *c_Mod		(Frame *frame);
extern insn  *c_MakePoint	(Frame *frame);
extern insn  *c_BitShift	(Frame *frame);
extern insn  *c_Div		(Frame *frame);
extern insn  *c_BitAnd		(Frame *frame);
extern insn  *c_BitOr		(Frame *frame);
extern void   c_Equivalent	(Frame *frame);
extern void   c_Class		(Frame *frame);
extern insn  *c_BlockCopy	(Frame *frame);
extern insn  *c_bBlockCopy	(Frame *frame);

extern BlockContext *g_c_Lambda	(Frame *frame, oop startPC, oop nArgs);
extern void	       c_Lambda	(Frame *frame, int pcArgs);

extern BlockContext *g_c_bLambda(Frame *frame, oop startPC, oop nArgs);
extern void	       c_bLambda(Frame *frame, int pcArgs);


#endif // _j_machine_h
