// pmcache.h -- polymorphic cache
// 
// Author: Ian.Piumarta@INRIA.Fr
// 
// Last edited: Fri Dec 31 16:32:54 1999 by piumarta (Ian Piumarta) on pingu

#ifndef _j_pmcache_h
#define _j_pmcache_h


#include "archdep.h"


// Size of relink cache.  Must be a power of 2.  Never purged: make it
// as large as you like.
static const RelinkCacheSize=  1024;

// Inline cache promoted to polymorphic after this many relinks.
static const RelinkCacheDelay=   32;


class RelinkCache
{
private:
  insn   *sendSite;
  size_t  relinkCount;

  static RelinkCache line[];

  inline void init(insn *senderPc)
    {
      sendSite= senderPc;
      relinkCount= RelinkCacheDelay;
    }

  inline bool promote(void)
    {
      printf("relink hit %p: %p %d\n", this, senderPc, relinkCount);
      return --relinkCount == 0;
    }

public:
  inline static bool noteRelink(insn *senderPc)
    {
      const unsigned index= (((unsigned)senderPc) & (RelinkCacheSize - 1)) >> 2;
      if (line[index].sendSite == senderPc)
	{
	  return line[index].promote();
	}
      else
	{
	  line[index].init(senderPc);
	  return false;
	}
    }
};


#endif // _j_pmcache_h
