// primProcess.cc -- process-related primitives
// 
// Author: Ian.Piumarta@INRIA.Fr
// 
// Last edited: 2000-11-17 15:12:28 by piumarta on emilia.rd.wdi.disney.com



#include "debug.h"
#include "archdep.h"
#include "generate.h"
#include "machine.h"
#include "primitive.h"

#include "Frame.h"



extern "C" { void primitiveResume(void); }

//  activeContext instructionPointer method receiver theHomeContext
extern void j_primitiveResume(NativeMethod *nMeth, Frame *sender)
{
  // we intercept #transferTo: in order to avoid all sends of
  // #newActiveContext, which is the only place from within process
  // handling where the above variables are referenced.
  PRINTF(("primitiveResume: "));  PRINTLN(sender->stackValue(0)->asProcess());

  assert(activeFrame == sender);
#ifndef NEW_PRIMITIVES
  assert (stackPointer == sender->stackp);
#endif
  primitiveResume();

  if (successFlag == false) printf(("RESUME FAILURE\n"));

  // if control reaches here, we did not transfer
  assert(activeFrame == sender);
}



extern "C" { void primitiveSignal(void); }

//  activeContext instructionPointer method receiver theHomeContext
extern void j_primitiveSignal(NativeMethod *nMeth, Frame *sender)
{
  // redundant: we already set stackPointer in c_primitive
  PRINTF(("primitiveSignal: "));  PRINTLN(sender->stackValue(0));

  assert(activeFrame == sender);
#ifndef NEW_PRIMITIVES
  assert(stackPointer == sender->stackp);
#endif
  primitiveSignal();

  if (successFlag == false) printf(("SIGNAL FAILURE\n"));

  // if control reaches here, we did not transfer
  assert(activeFrame == sender);
}



extern "C" { void primitiveSuspend(void); }

//  activeContext instructionPointer method receiver theHomeContext
extern void j_primitiveSuspend(NativeMethod *nMeth, Frame *sender)
{
  // redundant: we already set stackPointer in c_primitive
  PRINTF(("primitiveSuspend: "));  PRINTLN(sender->stackValue(0)->asProcess());

  assert(activeFrame == sender);
#ifndef NEW_PRIMITIVES
  assert(stackPointer == sender->stackp);
#endif
  primitiveSuspend();

  if (successFlag == false) printf(("SUSPEND FAILURE\n"));

  // if control reaches here, we did not transfer
  assert(activeFrame == sender);
}



extern "C" { void primitiveWait(void); }

//  activeContext instructionPointer method receiver theHomeContext
extern void j_primitiveWait(NativeMethod *nMeth, Frame *sender)
{
  // redundant: we already set stackPointer in c_primitive
  PRINTF(("primitiveWait: "));  PRINTLN(sender->stackValue(0));

  assert(activeFrame == sender);
  primitiveWait();

  if (successFlag == false) printf("WAIT FAILURE\n");

  // if control reaches here, we did not transfer
  assert(activeFrame == sender);
}
