// primitive.h
// 
// Author: Ian.Piumarta@INRIA.Fr
// 
// Last edited: 2000-11-29 11:45:00 by piumarta on emilia.rd.wdi.disney.com

#ifndef _j_primitive_h
#define _j_primitive_h

class NativeMethod;
class Frame;

#include "archdep.h"

#include "primitives.h"

#define	NEW_PRIMITIVES

#ifdef NEW_PRIMITIVES
# include "Object.h"
  extern oop primitiveArguments[];
#endif

class NativeMethod;
class Frame;

typedef void  (*j_primitive)(NativeMethod *, Frame *);
typedef insn *(*j_controlPrimitive)(NativeMethod *, Frame *);

extern void prim_initialise(void);

extern void prim_markArgs(void);
extern void prim_mapArgs(void);

extern void  j_primitiveLoadInstVar(NativeMethod *nMeth, Frame *sender);
extern void  j_primitiveClone(NativeMethod *nMeth, Frame *sender);
extern void  j_primitiveStoreStackp(NativeMethod *nMeth, Frame *sender);
extern void  j_primitiveSize(NativeMethod *nMeth, Frame *sender);
extern void  j_primitiveAt(NativeMethod *nMeth, Frame *sender);
extern void  j_primitiveAtPut(NativeMethod *nMeth, Frame *sender);
extern void  j_primitiveInstVarAt(NativeMethod *nMeth, Frame *sender);
extern void  j_primitiveInstVarAtPut(NativeMethod *nMeth, Frame *sender);
extern void  j_primitiveInstVarsPutFromStack(NativeMethod *nMeth, Frame *sender);
extern void  j_primitiveStringAt(NativeMethod *nMeth, Frame *sender);
extern void  j_primitiveStringAtPut(NativeMethod *nMeth, Frame *sender);
extern void  j_primitiveSnapshot(NativeMethod *nMeth, Frame *sender);
extern void  j_primitiveExternalCall(NativeMethod *nMeth, Frame *sender);
extern void  j_primitiveObsoleteIndexedPrimitive(NativeMethod *nMeth, Frame *sender);
extern insn *j_primitiveDoPrimitiveWithArgs(NativeMethod *nMeth, Frame *sender);
extern insn *j_primitivePerform(NativeMethod *nMeth, Frame *sender);
extern insn *j_primitivePerformInSuperclass(NativeMethod *nMeth, Frame *sender);
extern insn *j_primitivePerformWithArgs(NativeMethod *nMeth, Frame *sender);
extern void  j_primitiveResume(NativeMethod *nMeth, Frame *sender);
extern void  j_primitiveSignal(NativeMethod *nMeth, Frame *sender);
extern void  j_primitiveSuspend(NativeMethod *nMeth, Frame *sender);
extern void  j_primitiveWait(NativeMethod *nMeth, Frame *sender);
extern void  j_primitiveBlockCopy(NativeMethod *nMeth, Frame *sender);
extern insn *j_primitiveValue(NativeMethod *nMeth, Frame *sender);
extern insn *j_primitiveValueWithArgs(NativeMethod *nMeth, Frame *sender);

extern void j_clearProfile(void);
extern void j_dumpProfile(void);
extern void j_startProfiling(void);
extern void j_stopProfiling(void);

#endif // _j_primitive_h
